Rem 10gR1

set timing on

COMMIT;

ALTER SESSION ENABLE PARALLEL DML;

Rem *****
Rem PARALLEL INSERT
Rem *****

INSERT /*+ APPEND PARALLEL(SALES,4) */ INTO sales
(
  PROD_ID,
  CUST_ID,
  TIME_ID,
  CHANNEL_ID,
  PROMO_ID,
  QUANTITY_SOLD,
  AMOUNT_SOLD
)
SELECT /*+ PARALLEL (sales_delta_XT,4) */
  PROD_ID,
  CUST_ID,
  TIME_ID,
  case CHANNEL_ID
  when 'S' then 3
  when 'T' then 9
  when 'C' then 5
  when 'I' then 4
  when 'P' then 2
  else 99
  end,
  PROMO_ID,
  sum(QUANTITY_SOLD),
  sum(AMOUNT_SOLD)
FROM SALES_DELTA_XT
GROUP BY 1, prod_id,time_id,cust_id,channel_id,promo_id;

set timing off

SELECT * FROM TABLE(dbms_xplan.display_cursor);

Rem   Alternatively, you can control the successful parallel DML with a V$ view
SELECT * FROM   v$pq_sesstat 
WHERE  statistic in ('DML Parallelized','Allocation Height');
