REM   ILM Assistant Demo
REM   Version 2.0



REM Audit Access - Need to restart instance 
REM connect sys/oracle as sysdba;
REM ALTER SYSTEM SET audit_trail = "DB_EXTENDED" SCOPE=SPFILE;
REM ALTER SYSTEM SET audit_sys_operations = TRUE SCOPE=SPFILE;
REM shutdown immediate;
REM startup; 

REM  Drop the ILM demo User	
connect system/oracle;
drop user ilm_demo  cascade;

REM Create Default Tablespace for all basic demo stuff
DROP TABLESPACE ilm_demo including contents and datafiles cascade constraints;

CREATE SMALLFILE TABLESPACE "ILM_DEMO" DATAFILE 'ilm_demo' SIZE 20M AUTOEXTEND ON NEXT 5M MAXSIZE UNLIMITED LOGGING EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO;

REM  Create an ILM User
CREATE USER ilm_demo PROFILE "DEFAULT" IDENTIFIED BY "ilm"  DEFAULT TABLESPACE "ILM_DEMO" TEMPORARY TABLESPACE "TEMP" ACCOUNT UNLOCK;
GRANT "CONNECT" TO ilm_demo;
grant dba to ilm_demo;


REM Setup the tablespaces for the data 
DROP TABLESPACE q1_orders including contents and datafiles cascade constraints;
DROP TABLESPACE q2_orders including contents and datafiles cascade constraints;
DROP TABLESPACE q3_orders including contents and datafiles cascade constraints;
DROP TABLESPACE q4_orders including contents and datafiles cascade constraints;
DROP TABLESPACE "2003_ORDERS" including contents and datafiles cascade constraints;
DROP TABLESPACE "2004_ORDERS" including contents and datafiles cascade constraints;
DROP TABLESPACE "2005_ORDERS" including contents and datafiles cascade constraints;
DROP TABLESPACE old_orders including contents and datafiles cascade constraints;

CREATE SMALLFILE TABLESPACE q1_orders DATAFILE 'q1_orders' SIZE 5M AUTOEXTEND ON NEXT 1M MAXSIZE UNLIMITED LOGGING EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;

CREATE SMALLFILE TABLESPACE q2_orders DATAFILE 'q2_orders' SIZE 5M AUTOEXTEND ON NEXT 1M MAXSIZE UNLIMITED LOGGING EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;

CREATE SMALLFILE TABLESPACE q3_orders DATAFILE 'q3_orders' SIZE 5M AUTOEXTEND ON NEXT 1M MAXSIZE UNLIMITED LOGGING EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;

CREATE SMALLFILE TABLESPACE q4_orders DATAFILE 'q4_orders' SIZE 5M AUTOEXTEND ON NEXT 1M MAXSIZE UNLIMITED LOGGING  EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;

CREATE SMALLFILE TABLESPACE "2003_ORDERS" DATAFILE '2003_orders' SIZE 5m AUTOEXTEND ON NEXT 10M MAXSIZE UNLIMITED LOGGING EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;

CREATE SMALLFILE TABLESPACE "2004_ORDERS"  DATAFILE '2004_orders' SIZE 5m AUTOEXTEND ON NEXT 10M MAXSIZE UNLIMITED LOGGING EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;

CREATE SMALLFILE TABLESPACE "2005_ORDERS"  DATAFILE '2005_orders' SIZE 5m AUTOEXTEND ON NEXT 10M MAXSIZE UNLIMITED LOGGING EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;

CREATE SMALLFILE TABLESPACE old_orders DATAFILE 'old_orders' SIZE 5m AUTOEXTEND ON NEXT 50M MAXSIZE UNLIMITED LOGGING EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;

REM File for unpartitioned Table 

DROP TABLESPACE all_orders including contents and datafiles cascade constraints;

CREATE SMALLFILE TABLESPACE all_orders DATAFILE 'all_orders' SIZE 5m
AUTOEXTEND ON NEXT 5M MAXSIZE UNLIMITED LOGGING EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;


connect ilm_demo/ilm;

DROP TABLE allorders cascade constraints;
CREATE TABLE allorders (
    prod_id 		NUMBER 		NOT NULL,
    cust_id 		NUMBER 		NOT NULL,
    time_id 		DATE 		NOT NULL,
    channel_id 		NUMBER	 	NOT NULL,
    promo_id 		NUMBER 		NOT NULL,
    quantity_sold 	NUMBER(10,2) 	NOT NULL,
    amount_sold 	NUMBER(10,2) 	NOT NULL)
 PCTFREE 5 NOLOGGING   TABLESPACE all_orders;



DROP TABLE part_orders cascade constraints;
CREATE TABLE part_orders (
    prod_id 		NUMBER 		NOT NULL,
    cust_id 		NUMBER 		NOT NULL,
    time_id 		DATE 		NOT NULL,
    channel_id 		NUMBER	 	NOT NULL,
    promo_id 		NUMBER 		NOT NULL,
    quantity_sold 	NUMBER(10,2) 	NOT NULL,
    amount_sold 	NUMBER(10,2) 	NOT NULL)
 --
 -- table wide physical specs
 --
 PCTFREE 5 NOLOGGING   
 --
 -- partitions
 --  
 PARTITION BY RANGE (time_id)
  ( partition allorders_pre_2002 VALUES LESS THAN 
     (TO_DATE('2003-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE old_orders  ,
    partition allorders_2003 VALUES LESS THAN 
     (TO_DATE('2004-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE "2003_ORDERS"  ,
    partition allorders_2004 VALUES LESS THAN 
     (TO_DATE('2005-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE "2004_ORDERS"   ,
    partition allorders_2005 VALUES LESS THAN 
     (TO_DATE('2006-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE "2005_ORDERS"   ,
     partition allorders_q1_2006 VALUES LESS THAN 
     (TO_DATE('2006-04-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE q1_orders,
    partition allorders_q2_2006 VALUES LESS THAN 
     (TO_DATE('2006-07-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE q2_orders,
    partition allorders_q3_2006 VALUES LESS THAN 
     (TO_DATE('2006-10-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE q3_orders,
    partition allorders_q4_2006 VALUES LESS THAN 
     (TO_DATE('2006-11-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE q4_orders);

ALTER TABLE part_orders ENABLE ROW MOVEMENT;


REM Time Table
CREATE TABLE calendar 
 ( time_id   DATE)  TABLESPACE ilm_demo;
 
 INSERT INTO calendar SELECT time_id from times;
 commit;
 insert into calendar values ('1-JAN-2003');
 insert into calendar values ('5-JAN-2003');
 insert into calendar values ('5-APR-2003');
 insert into calendar values ('5-JUN-2003');
 insert into calendar values ('8-AUG-2003');
 insert into calendar values ('9-NOV-2003');
 commit;
  insert into calendar values ('1-JAN-2004');
  insert into calendar values ('5-JAN-2004');
  insert into calendar values ('5-APR-2004');
  insert into calendar values ('5-JUN-2004');
  insert into calendar values ('8-AUG-2004');
  insert into calendar values ('9-NOV-2004');
 commit;
   insert into calendar values ('1-JAN-2005');
   insert into calendar values ('5-JAN-2005');
   insert into calendar values ('5-APR-2005');
   insert into calendar values ('5-JUN-2005');
   insert into calendar values ('8-AUG-2005');
   insert into calendar values ('9-NOV-2005');
 commit;
    insert into calendar values ('1-JAN-2006');
    insert into calendar values ('5-JAN-2006');
    insert into calendar values ('5-APR-2006');
    insert into calendar values ('5-JUN-2006');
    insert into calendar values ('8-AUG-2006');
    insert into calendar values ('9-NOV-2006');
 commit;
 

------------------------

REM Now Populate the table allorders
REM select  count(*), time_id  from sh.sales where time_id <'1-DEC-1998' group by time_id;

insert /* append */ into allorders select * from sh.sales;
insert /* append */ into allorders select * from allorders;
rem insert /* append */ into allorders select * from allorders;
rem insert /* append */ into allorders select * from allorders;
commit;

update allorders set time_id='1-JAN-2003' where time_id='28-DEC-01' and rownum<500;
update allorders set time_id='5-APR-2003' where time_id='20-DEC-01' and rownum<650;
commit;
update allorders set time_id='5-JUN-2003' where time_id='18-DEC-01' and rownum<1250;
update allorders set time_id='8-AUG-2003' where time_id='27-NOV-01' and rownum<1250;
update allorders set time_id='9-NOV-2003' where time_id='18-OCT-01' and rownum<1250;
commit;
insert /* append */ into allorders select * from sh.sales;
commit;

update allorders set time_id='1-JAN-2004' where time_id='26-NOV-00' and rownum<500;
update allorders set time_id='5-APR-2004' where time_id='16-NOV-00' and rownum<1000;
update allorders set time_id='5-JUN-2004' where time_id='23-JUL-00' and rownum<900;
update allorders set time_id='8-AUG-2004' where time_id='31-MAY-00' and rownum<1270;
update allorders set time_id='9-NOV-2004' where time_id='18-APR-00' and rownum<1560;
commit;
insert /* append */ into allorders select * from sh.sales;
commit;

update allorders set time_id='1-JAN-2005' where time_id='27-NOV-99' and rownum<750;
update allorders set time_id='5-APR-2005' where time_id='17-NOV-99' and rownum<1000;
update allorders set time_id='5-JUN-2005' where time_id='18-OCT-99' and rownum<900;
update allorders set time_id='8-AUG-2005' where time_id='23-SEP-99' and rownum<1270;
update allorders set time_id='9-NOV-2005' where time_id='17-SEP-99' and rownum<1560;
commit;
insert /* append */ into allorders select * from sh.sales;
commit;

update allorders set time_id='1-JAN-2006' where time_id='27-NOV-98' and rownum<750;
update allorders set time_id='5-APR-2006' where time_id='31-OCT-98' and rownum<1000;
update allorders set time_id='5-JUN-2006' where time_id='20-AUG-98' and rownum<900;
update allorders set time_id='8-AUG-2006' where time_id='24-JUL-98' and rownum<1270;
commit;
insert /* append */  into allorders select * from sh.sales;
commit;


REM Now increase volume of data 

rem select  count(*), time_id  from allorders group by time_id;
 
  insert /* append */ into allorders select * from allorders where 
    time_id in ('1-JAN-2006', '5-APR-2006', '5-JUN-2006', '8-AUG-2006');
    commit;
  insert /* append */ into allorders select * from allorders where 
      time_id in ('1-JAN-2006', '5-APR-2006', '5-JUN-2006', '8-AUG-2006');
    commit;
  insert /* append */ into allorders select * from allorders where 
      time_id in ('1-JAN-2006', '5-APR-2006', '5-JUN-2006', '8-AUG-2006');
    commit;
  insert /* append */ into allorders select * from allorders where 
      time_id in ('1-JAN-2006', '5-APR-2006', '5-JUN-2006', '8-AUG-2006');
    commit;
  insert /* append */ into allorders select * from allorders where time_id in ('1-JAN-2006');
  insert /* append */ into allorders select * from allorders where time_id in ('1-JAN-2006');
    commit;
  insert /* append */ into allorders select * from allorders where time_id in ('1-JAN-2006');
  insert /* append */ into allorders select * from allorders where time_id in ('1-JAN-2006');
    commit;
  
  insert /* append */ into allorders select * from allorders where 
    time_id in ('1-JAN-2005', '5-APR-2005', '5-JUN-2005', '8-AUG-2005', '9-NOV-2005');
    commit;
  insert /* append */ into allorders select * from allorders where 
    time_id in ('1-JAN-2005', '5-APR-2005', '5-JUN-2005', '8-AUG-2005', '9-NOV-2005');
    commit;
  insert /* append */ into allorders select * from allorders where 
      time_id in ('1-JAN-2005', '5-APR-2005', '5-JUN-2005', '8-AUG-2005', '9-NOV-2005');
    commit;
  insert /* append */ into allorders select * from allorders where 
      time_id in ('1-JAN-2005', '5-APR-2005', '5-JUN-2005', '8-AUG-2005', '9-NOV-2005');
    commit;
  insert /* append */ into allorders select * from allorders where 
    time_id in ('1-JAN-2005', '5-APR-2005', '5-JUN-2005', '8-AUG-2005', '9-NOV-2005');
    commit;
  insert /* append */ into allorders select * from allorders where 
    time_id in ('1-JAN-2005', '5-APR-2005', '5-JUN-2005', '8-AUG-2005', '9-NOV-2005');
    commit;
rem   insert /* append */ into allorders select * from allorders where 
    time_id in ('1-JAN-2005', '5-APR-2005', '5-JUN-2005', '8-AUG-2005', '9-NOV-2005');
    commit;
rem   insert /* append */ into allorders select * from allorders where 
    time_id in ('1-JAN-2005', '5-APR-2005', '5-JUN-2005', '8-AUG-2005', '9-NOV-2005');
    commit;
  
  
    insert /* append */ into allorders select * from allorders where 
      time_id in ('1-JAN-2004', '5-APR-2004', '5-JUN-2004', '8-AUG-2004', '9-NOV-2004');
      commit;
    insert /* append */ into allorders select * from allorders where 
      time_id in ('1-JAN-2004', '5-APR-2004', '5-JUN-2004', '8-AUG-2004', '9-NOV-2004');
      commit;
    insert /* append */ into allorders select * from allorders where 
      time_id in ('1-JAN-2004', '5-APR-2004', '5-JUN-2004', '8-AUG-2004', '9-NOV-2004');
      commit;
    insert /* append */ into allorders select * from allorders where 
      time_id in ('1-JAN-2004', '5-APR-2004', '5-JUN-2004', '8-AUG-2004', '9-NOV-2004');
      commit;
    insert /* append */ into allorders select * from allorders where 
      time_id in ('1-JAN-2004', '5-APR-2004', '5-JUN-2004', '8-AUG-2004', '9-NOV-2004');
      commit;
rem     insert /* append */ into allorders select * from allorders where 
      time_id in ('1-JAN-2004', '5-APR-2004', '5-JUN-2004', '8-AUG-2004', '9-NOV-2004');
      commit;
rem    insert /* append */ into allorders select * from allorders where 
      time_id in ('1-JAN-2004', '5-APR-2004', '5-JUN-2004', '8-AUG-2004', '9-NOV-2004');
      commit;
    
    
     insert /* append */ into allorders select * from allorders where 
       time_id in ('1-JAN-2003', '5-APR-2003', '5-JUN-2003', '8-AUG-2003', '9-NOV-2003');
       commit;
     insert /* append */ into allorders select * from allorders where 
       time_id in ('1-JAN-2003', '5-APR-2003', '5-JUN-2003', '8-AUG-2003', '9-NOV-2003');
       commit;
     insert /* append */ into allorders select * from allorders where 
        time_id in ('1-JAN-2003', '5-APR-2003', '5-JUN-2003', '8-AUG-2003', '9-NOV-2003');
        commit;
     insert /* append */ into allorders select * from allorders where 
        time_id in ('1-JAN-2003', '5-APR-2003', '5-JUN-2003', '8-AUG-2003', '9-NOV-2003');
        commit;
     insert /* append */ into allorders select * from allorders where 
        time_id in ('1-JAN-2003', '5-APR-2003', '5-JUN-2003', '8-AUG-2003', '9-NOV-2003');
        commit;
rem     insert /* append */ into allorders select * from allorders where 
        time_id in ('1-JAN-2003', '5-APR-2003', '5-JUN-2003', '8-AUG-2003', '9-NOV-2003');
        commit;
rem     insert /* append */ into allorders select * from allorders where 
        time_id in ('1-JAN-2003', '5-APR-2003', '5-JUN-2003', '8-AUG-2003', '9-NOV-2003');
        commit;


insert /* append */ into allorders select * from allorders;
commit;
REM insert /* append */ into allorders select * from allorders;
REM commit;
  
rem insert /* append */ into allorders select * from sh.sales;
rem insert /* append */ into allorders select * from sh.sales;
rem insert /* append */ into allorders select * from sh.sales;
rem insert /* append */ into allorders select * from sh.sales;
rem commit;

REM ******* I M P O R T A N T *******

REM This takes a long time but is needed so the lifecycle tables is quick
REM create index time_all_idx on allorders (time_id) tablespace all_orders ;

REM -----------------------------------------------------------------------

REM Now Populate the table part_orders

insert /* append */ into part_orders  select * from sh.sales;
insert /* append */ into part_orders  select * from part_orders;
rem insert /* append */ into part_orders  select * from part_orders; 
rem insert /* append */ into part_orders  select * from part_orders;
commit;

update part_orders  set time_id='1-JAN-2003' where time_id='28-DEC-01' and rownum<500;
update part_orders  set time_id='5-APR-2003' where time_id='20-DEC-01' and rownum<650;
commit;
update part_orders  set time_id='5-JUN-2003' where time_id='18-DEC-01' and rownum<1250;
update part_orders  set time_id='8-AUG-2003' where time_id='27-NOV-01' and rownum<1250;
update part_orders  set time_id='9-NOV-2003' where time_id='18-OCT-01' and rownum<1250;
commit;
insert /* append */ into part_orders  select * from sh.sales;
commit;

update part_orders  set time_id='1-JAN-2004' where time_id='26-NOV-00' and rownum<500;
update part_orders  set time_id='5-APR-2004' where time_id='16-NOV-00' and rownum<1000;
update part_orders  set time_id='5-JUN-2004' where time_id='23-JUL-00' and rownum<900;
update part_orders  set time_id='8-AUG-2004' where time_id='31-MAY-00' and rownum<1270;
update part_orders  set time_id='9-NOV-2004' where time_id='18-APR-00' and rownum<1560;
commit;
insert /* append */ into part_orders  select * from sh.sales;
commit;

update part_orders  set time_id='1-JAN-2005' where time_id='27-NOV-99' and rownum<750;
update part_orders  set time_id='5-APR-2005' where time_id='17-NOV-99' and rownum<1000;
update part_orders  set time_id='5-JUN-2005' where time_id='18-OCT-99' and rownum<900;
update part_orders  set time_id='8-AUG-2005' where time_id='23-SEP-99' and rownum<1270;
update part_orders  set time_id='9-NOV-2005' where time_id='17-SEP-99' and rownum<1560;
commit;
insert /* append */ into part_orders  select * from sh.sales;
commit;

update part_orders  set time_id='1-JAN-2006' where time_id='27-NOV-98' and rownum<750;
update part_orders  set time_id='5-APR-2006' where time_id='31-OCT-98' and rownum<1000;
update part_orders  set time_id='5-JUN-2006' where time_id='20-AUG-98' and rownum<900;
update part_orders  set time_id='8-AUG-2006' where time_id='24-JUL-98' and rownum<1270;
commit;
insert /* append */  into part_orders  select * from sh.sales;
commit;


create index time_part_idx on part_orders (time_id) tablespace all_orders local;


REM ----------------------------------------------------------------------------------

DROP TABLESPACE cc_this_month including contents and datafiles cascade constraints;
DROP TABLESPACE cc_prev_month including contents and datafiles cascade constraints;
DROP TABLESPACE cc_this_year including contents and datafiles cascade constraints;
DROP TABLESPACE cc_old_tran including contents and datafiles cascade constraints;


CREATE SMALLFILE TABLESPACE cc_this_month DATAFILE 'cc_this_month' SIZE 2M 
AUTOEXTEND ON NEXT 1M MAXSIZE UNLIMITED LOGGING 
EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;

CREATE SMALLFILE TABLESPACE cc_prev_month DATAFILE 'cc_prev_month' SIZE 2M 
AUTOEXTEND ON NEXT 1M MAXSIZE UNLIMITED LOGGING 
EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;

CREATE SMALLFILE TABLESPACE cc_this_year DATAFILE 'cc_this_year' SIZE 2M 
AUTOEXTEND ON NEXT 1M MAXSIZE UNLIMITED LOGGING 
EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;

CREATE SMALLFILE TABLESPACE cc_old_tran DATAFILE 'cc_old_tran' SIZE 2M 
AUTOEXTEND ON NEXT 1M MAXSIZE UNLIMITED LOGGING 
EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;



REM Credit Card Transactions
DROP TABLE cc_tran cascade constraints;
CREATE TABLE cc_tran (
    cc_no  		      VARCHAR2(16) NOT NULL,
    tran_dt 		DATE 		 NOT NULL,
    entry_dt 		DATE 		 NOT NULL,
    ref_no   		NUMBER	 NOT NULL,
    description         VARCHAR2(30) NOT NULL,
    tran_amt    	      NUMBER(10,2) NOT NULL)
 --
 -- table wide physical specs
 --
 PCTFREE 5 NOLOGGING   
 --
 -- partitions
 --  
 PARTITION BY RANGE (tran_dt)
  ( partition very_old_cc_trans VALUES LESS THAN 
     (TO_DATE('1996-10-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_old_tran ,
    partition old_cc_trans VALUES LESS THAN 
     (TO_DATE('1998-10-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_old_tran,
    partition all_year_cc_trans VALUES LESS THAN 
     (TO_DATE('2004-10-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_this_year,
    partition this_year_cc_trans VALUES LESS THAN 
     (TO_DATE('2005-07-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_this_year,
    partition recent_cc_trans VALUES LESS THAN 
    (TO_DATE('2005-09-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_prev_month,
    partition new_cc_tran VALUES LESS THAN 
     (TO_DATE('2005-10-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_this_month);

	
ALTER TABLE cc_tran ENABLE ROW MOVEMENT;

DROP TABLE survey cascade constraints;
CREATE TABLE survey (
    survey_no  		      VARCHAR2(16) NOT NULL,
    survey_dt 		DATE 		 NOT NULL,
    description         VARCHAR2(30) NOT NULL)
     TABLESPACE  all_orders;


REM ----------------------------------------------------------------------------------

REM Audit Transactions
DROP TABLE user_audit cascade constraints;
CREATE TABLE user_audit (
    aud_no  		VARCHAR2(16) NOT NULL,
    entry_dt 		DATE 		 NOT NULL,
    description         VARCHAR2(30) NOT NULL)
 --
 -- table wide physical specs
 --
 PCTFREE 5 NOLOGGING   
 --
 -- partitions
 --  
 PARTITION BY RANGE (entry_dt)
  ( partition old_aud2 VALUES LESS THAN 
    (TO_DATE('2003-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_this_year,
    partition old_aud VALUES LESS THAN 
    (TO_DATE('2004-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_this_year,
    partition recent_aud VALUES LESS THAN 
    (TO_DATE('2005-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_this_year,
    partition new_aud VALUES LESS THAN 
     (TO_DATE('2006-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_this_month);

	
ALTER TABLE user_audit ENABLE ROW MOVEMENT;

REM -----------------------------------------------------------------------------------

DROP TABLESPACE ilm_orders including contents and datafiles cascade constraints;

CREATE SMALLFILE TABLESPACE ilm_orders DATAFILE 'ilm_orders' SIZE 1250m
AUTOEXTEND ON NEXT 1M MAXSIZE UNLIMITED LOGGING 
EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;

DROP TABLE orders cascade constraints;
CREATE TABLE orders (
    prod_id 		NUMBER 		NOT NULL,
    cust_id 		NUMBER 		NOT NULL,
    time_id 		DATE 		NOT NULL,
    channel_id 		NUMBER	 	NOT NULL,
    promo_id 		NUMBER 		NOT NULL,
    quantity_sold 	NUMBER(10,2) 	NOT NULL,
    amount_sold 	NUMBER(10,2) 	NOT NULL)
     TABLESPACE ilm_orders;
    
    insert /* append */ into orders select * from allorders 
      where time_id >= '01-OCT-2006' and time_id <= '31-DEC-2006';
      
REM 40608 rows
    insert /* append */ into orders select * from allorders 
      where time_id >= '01-JUL-2006' and time_id <= '30-SEP-2006';  
      
REM 60736 rows
    insert /* append */ into orders select * from allorders 
      where time_id >= '01-APR-2006' and time_id <= '30-JUN-2006'; 
      
REM 383488 rows
    insert /* append */ into orders select * from allorders 
      where time_id >= '01-JAN-2006' and time_id <= '31-MAR-2006'; 
      
REM 2.8m
    insert /* append */ into orders select * from allorders 
      where time_id >= '01-JAN-2005' and time_id <= '31-DEC-2005'; 
      
REM 1.3m
    insert /* append */ into orders select * from allorders 
      where time_id >= '01-JAN-2004' and time_id <= '31-DEC-2004'; 
      
REM 1.2m
    insert /* append */ into orders select * from allorders 
      where time_id >= '01-JAN-2003' and time_id <= '31-DEC-2003'; 
      
REM 26m     
    insert /* append */ into orders select * from allorders 
      where time_id < '31-DEC-2003'; 
    
commit;


create index time_idx on orders (time_id) tablespace ilm_orders;

REM =====================================================================


DROP TABLE neworders cascade constraints;
CREATE TABLE neworders (
    prod_id 		NUMBER 		NOT NULL,
    cust_id 		NUMBER 		NOT NULL,
    time_id 		DATE 		NOT NULL,
    channel_id 		NUMBER	 	NOT NULL,
    promo_id 		NUMBER 		NOT NULL,
    quantity_sold 	NUMBER(10,2) 	NOT NULL,
    amount_sold 	NUMBER(10,2) 	NOT NULL)
     TABLESPACE ilm_orders;
    
    insert /* append */ into neworders select * from allorders 
      where time_id >= '01-OCT-2006' and time_id <= '31-DEC-2006';

    insert /* append */ into neworders select * from allorders 
      where time_id >= '01-JUL-2006' and time_id <= '30-SEP-2006' and rownum<100;  

    insert /* append */ into neworders select * from allorders 
      where time_id >= '01-APR-2006' and time_id <= '30-JUN-2006' and rownum<100; 
     
    insert /* append */ into new orders select * from allorders 
      where time_id >= '01-JAN-2006' and time_id <= '31-MAR-2006' and rownum<100; 

    insert /* append */ into neworders select * from allorders 
      where time_id >= '01-JAN-2005' and time_id <= '31-DEC-2005' and rownum<1000; 
     
    insert /* append */ into neworders select * from allorders 
      where time_id >= '01-JAN-2004' and time_id <= '31-DEC-2004' and rownum<1000;
commit; 
      
    insert /* append */ into neworders select * from allorders 
      where time_id >= '01-JAN-2003' and time_id <= '31-DEC-2003' and rownum<1000; 
           
    insert /* append */ into neworders select * from allorders 
      where time_id < '31-DEC-2003'and rownum < 3000; 
    
commit;


create index new_time_idx_ on neworders (time_id) tablespace ilm_orders;

REM =====================================================================

REM  Create an ILM User for Andy Demo

CREATE USER ailm  PROFILE "DEFAULT" IDENTIFIED BY "ilm"  DEFAULT TABLESPACE "ILM_DEMO" TEMPORARY TABLESPACE "TEMP" ACCOUNT UNLOCK;
GRANT "CONNECT" TO ailm;
grant dba to ailm;

connect ailm/ilm;

CREATE TABLE MYORDERS as select * from ilm_demo.neworders;


REM =====================================================================

REM setup some data 

insert into cc_tran VALUES ('1234567812345678','1-SEP-2005','3-SEP-2005',567321,'Boots PLC',54.25);
insert into cc_tran VALUES ('1234567342345678','2-SEP-2005','4-SEP-2005',237321,'American',423.25);
insert into cc_tran VALUES ('1234674512345579', '11-MAR-2005', '13-MAR-2005', 436723, 'AK', 925.67);
insert into cc_tran VALUES ('1234321443289856','1-MAR-2004','3-MAR-2004',783426,'British Airways',3003.67);
commit;


DROP TABLESPACE current_costs including contents and datafiles cascade constraints;

CREATE SMALLFILE TABLESPACE current_costs DATAFILE 'current_costs' SIZE 2M 
AUTOEXTEND ON NEXT 1M MAXSIZE UNLIMITED LOGGING 
EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO ;


DROP TABLE sales_costs cascade constraints;
CREATE TABLE sales_costs (
    prod_id 		NUMBER 		NOT NULL,
    cust_id 		NUMBER 		NOT NULL,
    time_id 		DATE 		NOT NULL,
    promo_id 		NUMBER 		NOT NULL,
    quantity_sold 	NUMBER(10,2) 	NOT NULL,
    cost_of_sale 	NUMBER(10,2) 	NOT NULL,
    amount_sold 	NUMBER(10,2) 	NOT NULL)
 --
 -- table wide physical specs
 --
 PCTFREE 5 NOLOGGING   
 --
 -- partitions
 --  
 PARTITION BY RANGE (time_id)
  ( partition costs_pre_2000 VALUES LESS THAN 
     (TO_DATE('2000-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE old_orders ,
    partition costs_pre_2001 VALUES LESS THAN 
     (TO_DATE('2001-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE old_orders ,
    partition costs_pre_2002 VALUES LESS THAN 
     (TO_DATE('2002-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE old_orders ,
    partition costs_pre_2003 VALUES LESS THAN 
     (TO_DATE('2003-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE old_orders ,
    partition costs_q1 VALUES LESS THAN 
     (TO_DATE('2004-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE q1_orders ,
    partition costs_q2 VALUES LESS THAN 
     (TO_DATE('2004-04-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE q2_orders,
    partition costs_q3 VALUES LESS THAN 
     (TO_DATE('2004-07-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE q3_orders,
    partition costs_q4 VALUES LESS THAN 
     (TO_DATE('2004-10-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE q4_orders,
    partition current_costs VALUES LESS THAN 
     (TO_DATE('2005-12-31 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE current_costs);

	
ALTER TABLE sales_costs ENABLE ROW MOVEMENT;

DROP TABLE mysales cascade constraints;
CREATE TABLE mysales (
    prod_id 		NUMBER 		NOT NULL,
    cust_id 		NUMBER 		NOT NULL,
    time_id 		DATE 		NOT NULL,
    promo_id 		NUMBER 		NOT NULL,
    quantity_sold 	NUMBER(10,2) 	NOT NULL,
    cost_of_sale 	NUMBER(10,2) 	NOT NULL,
    amount_sold 	NUMBER(10,2) 	NOT NULL)
   TABLESPACE ilm_orders; 


CREATE VIEW cc_nocard AS
 SELECT tran_dt, description, tran_amt from cc_tran order by tran_dt;

REM ############################################################################################
Make entries for Table Access by User

connect system/oracle;
CREATE USER ilm_user PROFILE "DEFAULT" IDENTIFIED BY "ilm" 
DEFAULT TABLESPACE "ILM_DEMO" TEMPORARY TABLESPACE "TEMP" ACCOUNT UNLOCK;
GRANT "CONNECT" TO ilm_demo;

CREATE USER ilm_apac PROFILE "DEFAULT" IDENTIFIED BY "ilm" 
DEFAULT TABLESPACE "ILM_DEMO" TEMPORARY TABLESPACE "TEMP" ACCOUNT UNLOCK;
GRANT "CONNECT" TO ilm_demo;

grant select on ilm_demo.cc_tran to ilm_user;
grant select,insert,delete,update on ilm_demo.cc_tran to ilm_demo;

grant select,insert on ilm_demo.cc_tran to ilm_apac;
grant update,delete on ilm_demo.cc_tran to ilm_apac;
revoke update,delete on ilm_demo.cc_tran from ilm_apac;

REM ############################################################################################

REM SQL Result Set 

SELECT tran_dt, description, tran_amt from  ilm_demo.cc_tran order by tran_dt;

SELECT cust_id, SUM(Amount_sold) from  ilm_demo.allorders group by cust_id where time_id > '1-JAN-2006';

SELECT SUM(amount_sold) from ilm_demo.orders where time_id <'1-JAN-2005' and time_id >'1-DEC-2003'


REM ############################################################################################

REM Make entries for Audit Trail 
REM
REM    *** MAKE SURE TABLE IS MANAGED BY ILM ASSISTANT OR ENTRIES WILL NOT APPEAR ***
REM
connect system/oracle;
AUDIT update, delete ON ilm_demo.cc_tran  BY ACCESS;

connect sys/oracle as sysdba;
grant select on dba_audit_trail to public;

connect ilm_demo/ilm;
delete from cc_tran WHERE cc_no='1234321443289856' AND tran_amt=3003.67;
commit;
insert into cc_tran VALUES ('1234321443289856','1-MAR-2004','3-MAR-2004',783426,'British Airways',3003.67);
commit;
update cc_tran set tran_amt = 1925.67 WHERE description='AK';
commit;

REM attempted deleted - everything is logged
delete from cc_tran WHERE cc_no='1235321443289856' AND tran_amt=3003.67;
commit;

REM Define a policy which records when any changes are made to allorders data. 

connect system/oracle;
execute dbms_fga.drop_policy ('sh','allorders', 'allorders_amtsold');
begin
   dbms_fga.add_policy (
      object_schema   => 'ILM_DEMO',
      object_name     => 'allorders',
      policy_name     => 'allorders_amtsold',
      audit_column    => 'amount_sold',
      statement_types => 'UPDATE, DELETE'
  );
end;
/

REM Define a policy which records when any changes or deletes a record over £5000
execute dbms_fga.drop_policy ('ilm_demo','cc_tran', 'VALUE_5000');
begin
   dbms_fga.add_policy (
      object_schema   => 'ilm_demo',
      object_name     => 'CC_TRAN',
      policy_name     => 'VALUE_5000',
      audit_column    => 'tran_amt',
      audit_condition => ' tran_amt > ''5000'' ',
      statement_types => ' UPDATE, DELETE'
  );
end;
/

connect ilm_demo/ilm;
insert into cc_tran VALUES ('1234321443289856','31-AUG-2005','3-SEP-2005',783427,'British Airways',5100.25);
insert into cc_tran VALUES 
('1234321273289856','23-JUL-2005','25-JUL-2005',787427,'British Airways', 10432.57);
commit;

delete from cc_tran WHERE cc_no='1234321273289856';
commit;

REM Define a policy which records when anybody looks at Larry's credit cards
begin
   dbms_fga.add_policy (
      object_schema   => 'ilm_demo',
      object_name     => 'CC_TRAN',
      policy_name     => 'VALUE_LARRY',
      audit_column    => 'cc_no',
      audit_condition => ' cc_no = ''1234321273289856'' ',
      statement_types => ' SELECT, UPDATE, DELETE '
  );
end;
/

REM Define an FGA policy which records viewing orders with a value over 10000
execute dbms_fga.drop_policy ('ilm_demo','allorders', 'VIEW_HIGH_VALUE_ORDERS');
begin
   dbms_fga.add_policy (
      object_schema   => 'ilm_demo',
      object_name     => 'allORDERS',
      policy_name     => 'VIEW_HIGH_VALUE_ORDERS',
      audit_column    => 'amount_sold',
      audit_condition => ' amount_sold > ''10000'' ',
      statement_types => ' SELECT, UPDATE, DELETE '
  );
end;
/

connect ilm_demo/ilm;
insert into cc_tran VALUES ('1234321443289856','31-AUG-2005','3-SEP-2005',783427,'British Airways',5100.25);
insert into cc_tran VALUES ('1234321273289856','23-JUL-2005','25-JUL-2005',787427,'British Airways', 10432.57);
commit;

REM select * from cc_tran WHERE cc_no='1234321273289856' order by tran_amt, tran_dt; 

REM select * from allorders where amount_sold > 10000;
commit;


REM Create a FGA policy with a function 

CREATE OR REPLACE PROCEDURE cc_high_value  IS
BEGIN
dbms_OUTPUT.put_line (' High Value Transaction ');
END ;
/

REM Define a policy which records any cc_tran over 10,000 
execute dbms_fga.drop_policy ('ilm_demo','cc_tran', 'High_value_tran');

begin
   dbms_fga.add_policy (
      object_schema   => 'ilm_demo',
      object_name     => 'cc_tran',
      policy_name     => 'High_Value_tran',
      audit_column    => 'tran_amt',
      audit_condition => 'tran_amt > 10000', 
      handler_schema  => 'ilm_demo',
      handler_module  => 'cc_high_value', 
      statement_types => 'INSERT,UPDATE, DELETE'
  );
end;
/

REM ############################################################################################

REM Create a Security Policy to allow user ILM_DEMO to see all data 

-- This function we see different data

CREATE OR REPLACE FUNCTION ilm_seehist (oowner IN VARCHAR2, ojname IN VARCHAR2)
   RETURN VARCHAR2 AS con VARCHAR2 (200);
BEGIN
 If SYS_CONTEXT('USERENV','CLIENT_INFO') = 'ILM_DEMO' THEN -- sees all data
   con:= '1=1';
 ELSIF SYS_CONTEXT('USERENV','CLIENT_INFO') = 'ILM' THEN -- sees after 1999
   con := 'time_id > ''31-Dec-1999'''; 
 ELSE                                                      -- others nothing
    con:= '1=2';
 END IF;
RETURN (con);
END ilm_seehist;
/

REM Then the policy is added with the DBMS_RLS package as follows:

BEGIN
DBMS_RLS.ADD_POLICY (object_schema=>'ILM_DEMO', object_name=>'allorders',
policy_name=>'ilm_view_history_data', function_schema=>'ilm_demo',
policy_function=>'ilm_seehist',
sec_relevant_cols=>'time_id');
END;
/



REM Then the policy is added with the DBMS_RLS package as follows:

BEGIN
DBMS_RLS.ADD_POLICY (object_schema=>'ILM_DEMO', object_name=>'Orders',
policy_name=>'Orders_view_history', function_schema=>'ILM_DEMO',
policy_function=>'ilm_seehist',
sec_relevant_cols=>'time_id');
END;
/


BEGIN
DBMS_RLS.ADD_POLICY (object_schema=>'ILM_DEMO', object_name=>'Part_orders',
policy_name=>'Orders_view_history', function_schema=>'ILM_DEMO',
policy_function=>'ilm_seehist',
sec_relevant_cols=>'time_id');
END;
/


REM ###########################################################################
REM Andy Demo

exp system/oracle file=odemo.dat owner=odemo grants=yes compress=y
exp system/oracle file=part_sales.dat tables=tl.part_orders  grants=yes compress=y


sqlplus system/oracle
drop user ilm_demo cascade;

REM  Create an ILM User
CREATE USER TL  PROFILE "DEFAULT" IDENTIFIED BY "ilm"  DEFAULT TABLESPACE "ILM_DEMO" TEMPORARY TABLESPACE "TEMP" ACCOUNT UNLOCK;
GRANT "CONNECT" TO TL;
grant dba to TL;

connect tl/ilm;

DROP TABLE sales  cascade constraints;
CREATE TABLE sales (
    prod_id 		NUMBER 		NOT NULL,
    cust_id 		NUMBER 		NOT NULL,
    time_id 		DATE 		NOT NULL,
    channel_id 		NUMBER	 	NOT NULL,
    promo_id 		NUMBER 		NOT NULL,
    quantity_sold 	NUMBER(10,2) 	NOT NULL,
    amount_sold 	NUMBER(10,2) 	NOT NULL )
    TABLESPACE ilm_orders;


insert /* append */ into sales  select * from sh.sales where rownum<500000;
commit;

update sales set time_id='1-JAN-2003' where time_id='28-DEC-01' and rownum<50;
update sales set time_id='5-APR-2003' where time_id='20-DEC-01' and rownum<65;
commit;
update sales set time_id='5-JUN-2003' where time_id='18-DEC-01' and rownum<10;
update sales set time_id='8-AUG-2003' where time_id='27-NOV-01' and rownum<10;
update sales set time_id='9-NOV-2003' where time_id='18-OCT-01' and rownum<10;
commit;


update sales set time_id='1-JAN-2004' where time_id='26-NOV-00' and rownum<16;
update sales set time_id='5-APR-2004' where time_id='16-NOV-00' and rownum<50;
update sales set time_id='5-JUN-2004' where time_id='23-JUL-00' and rownum<9;
update sales set time_id='8-AUG-2004' where time_id='31-MAY-00' and rownum<70;
update sales set time_id='9-NOV-2004' where time_id='18-APR-00' and rownum<15;
commit;


update sales set time_id='1-JAN-2005' where time_id='27-NOV-99' and rownum<7;
update sales set time_id='5-APR-2005' where time_id='17-NOV-99' and rownum<10;
update sales set time_id='5-JUN-2005' where time_id='18-OCT-99' and rownum<90;
update sales set time_id='8-AUG-2005' where time_id='23-SEP-99' and rownum<10;
update sales set time_id='9-NOV-2005' where time_id='17-SEP-99' and rownum<10;
commit;



update sales set time_id='1-JAN-2006' where time_id='27-NOV-98' and rownum<7;
update sales set time_id='5-APR-2006' where time_id='31-OCT-98' and rownum<10;
update sales set time_id='5-JUN-2006' where time_id='20-AUG-98' and rownum<9;
update sales set time_id='8-AUG-2006' where time_id='24-JUL-98' and rownum<70;
commit;

rem insert /* append */ into sales  select * from sales;
insert /* append */ into sales  select * from sales where rownum < 200000;
insert /* append */ into sales  select * from part_orders where rownum<500000;

commit;
insert /* append */ into sales  select * from part_orders where rownum<1000000;

commit;

alter table sales add (money1 number, money2 number, money3 number, money4 number, money5 number);

alter table sales add (money6 number, money7 number, money8 number, mone94 number);

create index time_idx on sales(time_id);

DROP TABLE part_orders cascade constraints;
CREATE TABLE part_orders (
    prod_id 		NUMBER 		NOT NULL,
    cust_id 		NUMBER 		NOT NULL,
    time_id 		DATE 		NOT NULL,
    channel_id 		NUMBER	 	NOT NULL,
    promo_id 		NUMBER 		NOT NULL,
    quantity_sold 	NUMBER(10,2) 	NOT NULL,
    amount_sold 	NUMBER(10,2) 	NOT NULL)
 --
 -- table wide physical specs
 --
 PCTFREE 5 NOLOGGING   
 --
 -- partitions
 --  
 PARTITION BY RANGE (time_id)
  ( partition allorders_pre_2002 VALUES LESS THAN 
     (TO_DATE('2003-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE old_orders  ,
    partition allorders_2003 VALUES LESS THAN 
     (TO_DATE('2004-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE "2003_ORDERS"  ,
    partition allorders_2004 VALUES LESS THAN 
     (TO_DATE('2005-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE "2004_ORDERS"   ,
    partition allorders_2005 VALUES LESS THAN 
     (TO_DATE('2006-01-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE "2005_ORDERS"   ,
     partition allorders_q1_2006 VALUES LESS THAN 
     (TO_DATE('2006-04-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE q1_orders,
    partition allorders_q2_2006 VALUES LESS THAN 
     (TO_DATE('2006-07-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE q2_orders,
    partition allorders_q3_2006 VALUES LESS THAN 
     (TO_DATE('2006-10-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE q3_orders,
    partition allorders_q4_2006 VALUES LESS THAN 
     (TO_DATE('2006-11-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE q4_orders);

ALTER TABLE part_orders ENABLE ROW MOVEMENT;
rem alter table part_orders add (stuff varchar2(100));

update /*append */  part_orders set stuff = '1234567890121234567890123456789012345678901234567890' ;
commit;

insert /*append */ into part_orders select * from sh.sales;
insert /*append */ into part_orders select * from sh.sales
 where rownum < 500000;
create index time_idx2 on part_orders(time_id);

DROP TABLE cc_tran cascade constraints;
CREATE TABLE cc_tran (
    cc_no  		      VARCHAR2(16) NOT NULL,
    tran_dt 		DATE 		 NOT NULL,
    entry_dt 		DATE 		 NOT NULL,
    ref_no   		NUMBER	 NOT NULL,
    description         VARCHAR2(30) NOT NULL,
    tran_amt    	      NUMBER(10,2) NOT NULL)
 --
 -- table wide physical specs
 --
 PCTFREE 5 NOLOGGING   
 --
 -- partitions
 --  
 PARTITION BY RANGE (tran_dt)
  ( partition very_old_cc_trans VALUES LESS THAN 
     (TO_DATE('1996-10-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_old_tran ,
    partition old_cc_trans VALUES LESS THAN 
     (TO_DATE('1998-10-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_old_tran,
    partition all_year_cc_trans VALUES LESS THAN 
     (TO_DATE('2004-10-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_this_year,
    partition this_year_cc_trans VALUES LESS THAN 
     (TO_DATE('2005-07-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_this_year,
    partition recent_cc_trans VALUES LESS THAN 
    (TO_DATE('2005-09-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_prev_month,
    partition new_cc_tran VALUES LESS THAN 
     (TO_DATE('2005-10-01 00:00:00','SYYYY-MM-DD HH24:MI:SS','NLS_CALENDAR=GREGORIAN')) TABLESPACE cc_this_month);

	
ALTER TABLE cc_tran ENABLE ROW MOVEMENT;


insert into cc_tran VALUES ('1234321443289856','31-AUG-2005','3-SEP-2005',783427,'British Airways',5100.25);
insert into cc_tran VALUES ('1234321273289856','23-JUL-2005','25-JUL-2005',787427,'British Airways', 10432.57);
commit;

insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;
insert /*append */ into cc_tran select * from cc_tran;




create index time_idx3 on cc_tran(tran_dt);

CREATE OR REPLACE FUNCTION ilm_seehist (oowner IN VARCHAR2, ojname IN VARCHAR2)
   RETURN VARCHAR2 AS con VARCHAR2 (200);
BEGIN
 If SYS_CONTEXT('USERENV','CLIENT_INFO') = 'TL' THEN -- sees all data
   con:= '1=1';
 ELSIF SYS_CONTEXT('USERENV','CLIENT_INFO') = 'ILM' THEN -- sees after 1999
   con := 'time_id > ''31-Dec-1999'''; 
 ELSE                                                      -- others nothing
    con:= '1=2';
 END IF;
RETURN (con);
END ilm_seehist;
/




BEGIN
DBMS_RLS.ADD_POLICY (object_schema=>'TL', object_name=>'SALES',
policy_name=>'ilm_view_history_data', function_schema=>'TL',
policy_function=>'ilm_seehist',
sec_relevant_cols=>'time_id');
END;
/

connect system/oracle;
AUDIT update, delete ON tl.cc_tran  BY ACCESS;

connect sys/oracle as sysdba;
grant select on dba_audit_trail to public;

connect tl/ilm;
delete from cc_tran WHERE cc_no='1234321443289856' AND tran_amt=3003.67;
commit;
insert into cc_tran VALUES ('1234321443289856','1-MAR-2004','3-MAR-2004',783426,'British Airways',3003.67);
commit;
update cc_tran set tran_amt = 1925.67 WHERE description='AK';
commit;

REM attempted deleted - everything is logged
delete from cc_tran WHERE cc_no='1235321443289856' AND tran_amt=3003.67;
commit;

REM Define a policy which records when any changes are made to allorders data. 

connect system/oracle;
execute dbms_fga.drop_policy ('tl','sales', 'allorders_amtsold');
begin
   dbms_fga.add_policy (
      object_schema   => 'TL',
      object_name     => 'SALES',
      policy_name     => 'allorders_amtsold',
      audit_column    => 'amount_sold',
      statement_types => 'UPDATE, DELETE'
  );
end;
/

REM Define a policy which records when any changes or deletes a record over £5000
execute dbms_fga.drop_policy ('tl','cc_tran', 'VALUE_5000');
begin
   dbms_fga.add_policy (
      object_schema   => 'tl',
      object_name     => 'CC_TRAN',
      policy_name     => 'VALUE_5000',
      audit_column    => 'tran_amt',
      audit_condition => ' tran_amt > ''5000'' ',
      statement_types => ' UPDATE, DELETE'
  );
end;
/

connect tl/ilm;
insert into cc_tran VALUES ('1234321443289856','31-AUG-2005','3-SEP-2005',783427,'British Airways',5100.25);
insert into cc_tran VALUES 
('1234321273289856','23-JUL-2005','25-JUL-2005',787427,'British Airways', 10432.57);
commit;

delete from cc_tran WHERE cc_no='1234321273289856';
commit;




REM select * from cc_tran WHERE cc_no='1234321273289856' order by tran_amt, tran_dt; 

REM select * from allorders where amount_sold > 10000;
commit;


REM Create a FGA policy with a function 

CREATE OR REPLACE PROCEDURE cc_high_value  IS
BEGIN
dbms_OUTPUT.put_line (' High Value Transaction ');
END ;
/

REM Define a policy which records any cc_tran over 10,000 
execute dbms_fga.drop_policy ('tl','cc_tran', 'High_value_tran');
begin
   dbms_fga.add_policy (
      object_schema   => 'tl',
      object_name     => 'cc_tran',
      policy_name     => 'High_Value_tran',
      audit_column    => 'tran_amt',
      audit_condition => 'tran_amt > 10000', 
      handler_schema  => 'ilm_demo',
      handler_module  => 'cc_high_value', 
      statement_types => 'INSERT,UPDATE, DELETE'
  );
end;
/

connect tl/ilm;
insert into cc_tran VALUES ('1234321443289856','31-AUG-2005','3-SEP-2005',783427,'British Airways',5100.25);
insert into cc_tran VALUES 
('1234321273289856','23-JUL-2005','25-JUL-2005',787427,'British Airways', 10432.57);
commit;

delete from cc_tran WHERE cc_no='1234321273289856';
commit;

create table gl_tran as select * from cc_tran;
commit;

SQL Result Set 

SELECT cust_id, SUM(Amount_sold) from tl.sales  group by cust_id ;

SELECT cust_id, SUM(Amount_sold) from tl.sales group by cust_id where time_id >'1_JAN-2006'

SELECT SUM(amount_sold) from tl.part_orders where time_id <'1-JAN-2005' and time_id >'1-DEC-2003'


REM ###########################################################################



